<?php
/* --------------------------------------------------------------
  OnGetSellingUnitModelEventListener.php 2020-06-24
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitModel\Database\Listener;

use Gambio\Shop\Properties\SellingUnitModel\Database\Exceptions\PropertiesCombinationIdDoesNotExistException;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\PropertiesCombinationIdDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\CombinationModelDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Service\ReadServiceInterface;
use Gambio\Shop\SellingUnit\Database\Configurations\AppendPropertiesModelConfiguration;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitModelEvent;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Model;
use Gambio\Shop\Properties\Properties\ValueObjects\CombinationId;

/**
 * Class OnGetSellingUnitModelEventListener
 * @package Gambio\Shop\Properties\SellingUnitModel\Database\Listener
 */
class OnGetSellingUnitModelEventListener
{
    /**
     * @var ReadServiceInterface
     */
    protected $service;

    /**
     * @var AppendPropertiesModelConfiguration
     */
    protected $appendPropertiesModel;


    /**
     * OnGetSellingUnitModelEventListener constructor.
     *
     * @param ReadServiceInterface               $service
     * @param AppendPropertiesModelConfiguration $appendPropertiesModel
     */
    public function __construct(
        ReadServiceInterface $service,
        AppendPropertiesModelConfiguration $appendPropertiesModel
    ) {
        $this->service               = $service;
        $this->appendPropertiesModel = $appendPropertiesModel;
    }


    /**
     *
     * @param OnGetSellingUnitModelEvent $event
     *
     * @throws PropertiesCombinationIdDoesNotExistException
     */
    public function __invoke(OnGetSellingUnitModelEvent $event)
    {
        $model = $event->model()->value();

        if ($event->combinationId() !== null) {
            $combinationModelDto = $this->getCombinationModel($event->combinationId());

            if ($combinationModelDto->combinationModel() !== '') {
                if ($this->appendPropertiesModel->value() === false) {
                    $model = '';
                }

                $model = $model === '' ? $combinationModelDto->combinationModel() : ($model . '-'
                                                                                     . $combinationModelDto->combinationModel());

                $event->setModel(new Model($model));
            }
        }
    }


    /**
     * @param CombinationId $combinationId
     *
     * @return CombinationModelDto
     * @throws PropertiesCombinationIdDoesNotExistException
     */
    protected function getCombinationModel(CombinationId $combinationId): CombinationModelDto
    {
        $dto = new PropertiesCombinationIdDto($combinationId->value());

        return $this->service->combinationModel($dto);
    }
}